/***********************************************************************
 *
 * Copyright (c) 2002 PalmSource, Inc. or its subsidiaries.
 * All rights reserved.
 *
 ***********************************************************************
 *
 * FILE: SMSCodecDefines.h
 *
 *
 * DESCRIPTION:
 *
 *
 * AUTHOR:
 *	October	10, 2002	Created by Yann Cheri (YCh)
 *	mmmm dd, yyyy	Now owned by .....
 *
 ***********************************************************************/
#ifndef SMSCODECDEFINES_H
#define SMSCODECDEFINES_H

/////////////////////////
// Parameters settings //
/////////////////////////
#define	kUndefinedSize				(Int32)-1
#define	kByteSize					8

#define	kUndefinedMask				0x0000
/*
#define	Optional					0
#define	Mandatory					1

#define	kTimeMask		0x0F00	
#define	kValidityMask	0x0F01
#define	kAddressMask	0x0F02
#define	kDataMask		0x0F03	
*/

#define kSMS_Option_Inactive		0x00
#define kSMS_Option_Active			0x01	

////////////////////////////////////////
// Maximum Data Size according to DCS //
////////////////////////////////////////
#define kSMS_Data_Coding_Default		0
#define kSMS_Data_Coding_8Bit			1
#define kSMS_Data_Coding_UCS2			2

#define kSMS_Data_MaxSize_UCS2			70
#define kSMS_Data_MaxSize_8Bit			140
#define kSMS_Data_MaxSize_Default		160

#define kSMS_Data_MaxSizePart_UCS2		67
#define kSMS_Data_MaxSizePart_8Bit		134
#define kSMS_Data_MaxSizePart_Default	153

#define kSMS_MaxPart					255

///////////////////////////////////////////
// TP-Message-Type-Indicator (TP-MTI)    //
// bits no 0 and 1 of the first byte of: //
// all PDUs								 //
///////////////////////////////////////////
#define kSMS_MTI_Mask				0x3	
#define kSMS_MTI_Deliver			0x0		// 0 0 SMS-DELIVER (in the direction SC to MS)
#define kSMS_MTI_DeliverReport		0x0		// 0 0 SMS-DELIVER-REPORT (in the direction MS to SC)
#define kSMS_MTI_StatusReport		0x2		// 1 0 SMS-STATUS-REPORT (in the direction SC to MS)
#define kSMS_MTI_Command			0x2		// 1 0 SMS-COMMAND (in the direction MS to SC)
#define kSMS_MTI_Submit				0x1		// 0 1 SMS-SUBMIT (in the direction MS to SC)
#define kSMS_MTI_SubmitReport		0x1		// 0 1 SMS-SUBMIT-REPORT (in the direction SC to MS)
#define kSMS_MTI_Reserved			0x3		// 1 1 Reserved - if received must be handled as a SMS-DELIVER

///////////////////////////////////////
// TP-More-Messages-to-Send (TP-MMS) //
// bit no 2 of the first byte of:    //
// SMS-DELIVER		 				 //		
// SMS-STATUS-REPORT				 //
///////////////////////////////////////
#define kSMS_MMS_Mask				0x4	
#define kSMS_MMS_MoreMessages		0x0		// 0 More messages are waiting for the MS in this SC
#define kSMS_MMS_NoMoreMessages		0x4		// 1 No more messages are waiting for the MS in this SC

//////////////////////////////////
// TP-Reject-Duplicates (TP-RD) //
// bit 2 of the first byte of:	//
// SMS-SUBMIT					//
//////////////////////////////////
#define kSMS_RD_Mask				0x04
#define kSMS_RD_Accept				0x00	// 0 Instruct the SC to accept an SMS-SUBMIT for an SM still held in the SC which has the same TP-MR and the same TP-DA as a previously submitted SM from the same OA.
#define kSMS_RD_Reject				0x04	// 1 Instruct the SC to reject an SMS-SUBMIT for an SM still held in the
											//	SC which has the same TP-MR and the same TP-DA as the previously submitted SM from
											//	the same OA. In this case an appropriate TP-FCS value will be returned in the SMS-SUBMIT-REPORT.

/////////////////////////////////////////
// TP-Validity-Period-Format (TP-VPF)  //
// bits no 3 and 4 of the first byte:  //
// SMS-SUBMIT						   //		
/////////////////////////////////////////
#define kSMS_VPF_Mask				0x18	
#define kSMS_VPF_NotPresent			0x00	// 0 0 TP-VP field not present
#define kSMS_VPF_Relative 			0x10	// 1 0 TP-VP field present - relative format
#define kSMS_VPF_Enhanced			0x08	// 0 1 TP-VP field present - enhanced format
#define kSMS_VPF_Absolute			0x18	// 1 1 TP-VP field present - absolute format

//////////////////////////////////////////
// TP-Status-Report-Indication (TP-SRI) //
// bit no. 5 of the first byte of:		//
// SMS-DELIVER							//		
//////////////////////////////////////////
#define kSMS_SRI_Mask				0x20
#define kSMS_SRI_NoStatusReport		0x00	// 0 A status report will not be returned to the SME
#define kSMS_SRI_StatusReport		0x20	// 1 A status report will be returned to the SME

///////////////////////////////////////
// TP-Status-Report-Request (TP-SRR) //
// bit no. 5 of the first byte of:   //
// SMS-SUBMIT	 					 //		
// SMS-COMMAND						 //
///////////////////////////////////////
#define kSMS_SRR_Mask				0x20
#define kSMS_SRR_NoStatusReport		0x00	// 0 A status report is not requested
#define kSMS_SRR_StatusReport		0x20	// 1 A status report is requested

/////////////////////////////////////////
// TP-Status-Report-Qualifier (TP-SRQ) //
// bit no. 5 of the first byte of:	   //
// SMS-STATUS-REPORT				   //		
/////////////////////////////////////////
#define kSMS_SRQ_Mask				0x20
#define kSMS_SRQ_ResultOfSubmit		0x00	// 0: The SMS-STATUS-REPORT is the result of a SMS-SUBMIT.
#define kSMS_SRQ_ResultOfCommand	0x20	// 1: The SMS-STATUS-REPORT is the result of an SMS-COMMAND e.g. an Enquiry.

/////////////////////////////////////////////
// TP-User-Data-Header-Indicator (TP-UDHI) //
// bit 6 of the first octet of:			   //
// SMS-SUBMIT							   //
// SMS-SUBMIT-REPORT					   //
// SMS-DELIVER							   //
// SMS-DELIVER-REPORT					   //
// SMS-STATUS-REPORT					   //
// SMS-COMMAND							   //
/////////////////////////////////////////////
#define kSMS_UDHI_Mask				0x40
#define kSMS_UDHI_NoHeader			0x00	// 0: The TP-UD field contains only the short message
#define kSMS_UDHI_Header			0x40	// 1: The beginning of the TP-UD field contains a Header in addition to the short message

////////////////////////////////////
// TP-Reply-Path (TP-RP)		  //
// bit no 7 of the first byte of: //
// SMS-DELIVER					  //	
// SMS-SUBMIT					  //
////////////////////////////////////
#define kSMS_RP_Mask				0x80
#define kSMS_RP_Inactive			0x00 	// 0: TP-Reply-Path parameter is not set in this SMS-SUBMIT/DELIVER
#define kSMS_RP_Active				0x80	// 1: TP-Reply-Path parameter is set in this SMS-SUBMIT/DELIVER

//////////////////////////////////
// TP-Message-Reference (TP-MR) //
// one byte						//
// SMS-SUBMIT	 				//		
// SMS-COMMAND					//
//////////////////////////////////
#define kSMS_MR_Mask				0xFF	// Size in bits	

////////////////////////////////////
// TP-Originating-Address (TP-OA) //
// see address fields			  //
////////////////////////////////////
#define kSMS_OA_Mask				variable

////////////////////////////////////
// TP-Originating-Address (TP-DA) //
// see address fields		  	  //
////////////////////////////////////
#define kSMS_DA_Mask				variable			

/////////////////////////////////////
// TP-Protocol-Identifier (TP-PID) //
// One byte						   //
/////////////////////////////////////
#define kSMS_PID_Mask				0xFF
#define kSMS_PID_Type_Mask			0xC0
#define kSMS_PID_Type_TI			0x00	// 0 0 Telematic interworking
#define kSMS_PID_Type_SM			0x40	// 0 1 Short Message Type
#define kSMS_PID_Type_Reserved		0x80	// 1 0 Reserved
#define kSMS_PID_Type_SCSpecific	0xC0	// 1 1 SC specific use

///////////////////////////////////////////////////
// If kSMS_PID value & kSMS_PID_Type_Mask = 0x00 //
// Telematic interworking						 //
// bit 5										 //
#define kSMS_PID_TI_Mask			0x20
#define kSMS_PID_TI_NoInterworking	0x00	// 0 : no interworking, but SME-to-SME protocol
#define kSMS_PID_TI_Interworking	0x20	// 1 : telematic interworking
// Telematic interworking type //
// bits 4 3 2 1 0			   //
#define kSMS_PID_TI_Interwork_Mask	0x1F
#define kSMS_PID_TI_Implicit 		0x00	// 00000 implicit - device type is specific to this SC, or can be concluded on the basis of the address
#define kSMS_PID_TI_Telex			0x01	// 00001 telex (or teletex reduced to telex format)
#define kSMS_PID_TI_TelefaxGroup3	0x02	// 00010 group 3 telefax
#define kSMS_PID_TI_TelefaxGroup4	0x03	// 00011 group 4 telefax
#define kSMS_PID_TI_VoiceTelephone	0x04	// 00100 voice telephone (i.e. conversion to speech)
#define kSMS_PID_TI_ERMES			0x05	// 00101 ERMES (European Radio Messaging System)
#define kSMS_PID_TI_NationalPaging	0x06	// 00110 National Paging system (known to the SC)
#define kSMS_PID_TI_Videotex		0x07	// 00111 Videotex (T.100/T.101)
#define kSMS_PID_TI_TeletexUnspec	0x08	// 01000 teletex, carrier unspecified
#define kSMS_PID_TI_TeletexPSPDN	0x09	// 01001 teletex, in PSPDN
#define kSMS_PID_TI_TeletexCSPDN	0x0A	// 01010 teletex, in CSPDN
#define kSMS_PID_TI_TeletexPSTN		0x0B	// 01011 teletex, in analog PSTN
#define kSMS_PID_TI_TeletexISDN		0x0C	// 01100 teletex, in digital ISDN
#define kSMS_PID_TI_UCI				0x0D	// 01101 UCI (Universal Computer Interface, ETSI DE/PS 3 01-3)
											// 01110..01111 (reserved, 2 combinations)
#define kSMS_PID_TI_Facility		0x10	// 10000 a message handling facility (known to the SC)
#define kSMS_PID_TI_X400			0x11	// 10001 any public X.400-based message handling system
#define kSMS_PID_TI_InternetEMail	0x12	// 10010 Internet Electronic Mail
											// 10011..10111 (reserved, 5 combinations)
											// 11000..11110 values specific to each SC, usage based on mutual agreement between the SME and the SC (7 combinations available for each SC)
#define kSMS_PID_TI_TIGSMMobileStation	0x1F	// 11111 A GSM mobile station. The SC converts the SM from the received TP-Data-Coding-Scheme to any data coding scheme supported by that MS (e.g. the default).
///////////////////////////////////////////////////
// If kSMS_PID value & kSMS_PID_Type_Mask = 0x40 //
// Short Message Type							 //
// bits 5 4 3 2 1 0								 //	
#define kSMS_PID_SM_Mask			0x3F
#define kSMS_PID_SM_Type0			0x00	// 000000 Short Message Type 0
#define kSMS_PID_SM_Type1			0x01	// 000001 Replace Short Message Type 1
#define kSMS_PID_SM_Type2			0x02	// 000010 Replace Short Message Type 2
#define kSMS_PID_SM_Type3			0x03	// 000011 Replace Short Message Type 3
#define kSMS_PID_SM_Type4			0x04	// 000100 Replace Short Message Type 4
#define kSMS_PID_SM_Type5			0x05	// 000101 Replace Short Message Type 5
#define kSMS_PID_SM_Type6			0x06	// 000110 Replace Short Message Type 6
#define kSMS_PID_SM_Type7			0x07	// 000111 Replace Short Message Type 7
											// 001000..011110 Reserved
#define kSMS_PID_SM_ReturnCallMessage	0x1F	// 011111 Return Call Message
						// 100000..111100 Reserved
#define kSMS_PID_SM_MEDataDownload	0x3D	// 111101 ME Data download
#define kSMS_PID_SM_MEDePersonalization 0x3E	// 111110 ME De-personalization Short Message
#define kSMS_PID_SM_SIMDataDownload	0x3F	// 111111 SIM Data download


#define kSMS_PID_Specific_Mask		0x3F
////////////////////////////////////
// TP-Data-Coding-Scheme (TP-DCS) //
// 1 byte						  //
////////////////////////////////////
#define kSMS_DCS_Mask				0xFF
#define kSMS_DCS_Type_Mask			0xC0
#define	kSMS_DCS_Type_GDC			0x00
#define	kSMS_DCS_Type_Other			0xC0

#define	kSMS_DCS_GDC_Mask			0x30	// 
#define	kSMS_DCS_GDC_Text_Mask		0x20
#define	kSMS_DCS_GDC_TextUnPacked	0x00	// 0: Text is uncompressed
#define	kSMS_DCS_GDC_TextPacked		0x20	// 1: Text is compressed using GSM standard compression
//
#define	kSMS_DCS_GDC_Class_Mask		0x10
#define	kSMS_DCS_GDC_ClassNo		0x00	// 0 0 No class
#define	kSMS_DCS_GDC_Class			0x10	// 0 1 Class
//
#define	kSMS_DCS_GDC_CT_Mask		0x03	// Class Type 
#define	kSMS_DCS_GDC_CT_0			0x00	// 0 0 Class 0
#define	kSMS_DCS_GDC_CT_1			0x01	// 0 1 Class 1, ME specific
#define	kSMS_DCS_GDC_CT_2			0x02	// 1 0 Class 2, SIM specific
#define	kSMS_DCS_GDC_CT_3			0x03	// 1 1 Class 3, TE specific
//
#define	kSMS_DCS_GDC_A_Mask			0x0C	// Alphabet
#define	kSMS_DCS_GDC_A_Default		0x00	// 0 0 Default alphabet
#define	kSMS_DCS_GDC_A_8Bits		0x04	// 0 1 8bits data
#define	kSMS_DCS_GDC_A_UCS2			0x08	// 1 0 UCS2
#define	kSMS_DCS_GDC_A_Reserved		0x0C	// 1 1 Reserved 
//
#define	kSMS_DCS_Other_Mask			0x30
#define	kSMS_DCS_Other_MW_Discard	0x00	// Message waiting indication: Discard
#define	kSMS_DCS_Other_MW_Store		0x10	// Message waiting indication: Store
#define	kSMS_DCS_Other_MW_StoreUCS2 0x20	// Message waiting indication: Store UCS2
#define	kSMS_DCS_Other_DC			0x30	// Data coding / Message class
//
#define	kSMS_DCS_Other_MW_Mask		0x0F
#define	kSMS_DCS_Other_MW_I_Mask	0x08	// Indication
#define	kSMS_DCS_Other_MW_I_Inactiv	0x00	// Indication inactive	
#define	kSMS_DCS_Other_MW_I_Active	0x08	// Indication active
//
#define	kSMS_DCS_Other_MW_IT_Mask	0x07	// Indication Type
#define	kSMS_DCS_Other_MW_IT_VoiceM	0x00	// 0 0 Voicemail message waiting
#define	kSMS_DCS_Other_MW_IT_Fax	0x01	// 0 1 Fax message waiting
#define	kSMS_DCS_Other_MW_IT_EMail	0x02	// 1 0 EMail message waiting
#define	kSMS_DCS_Other_MW_IT_Other	0x03	// 1 1 Other message waiting
//
#define	kSMS_DCS_Other_DC_A_Mask	0x04	// Alphabet
#define	kSMS_DCS_Other_DC_A_Default	0x00	// 0: Default Alphabet
#define	kSMS_DCS_Other_DC_A_8Bits	0x04	// 1: 8 bits data
//
#define	kSMS_DCS_Other_DC_CT_Mask	0x03	// Class Type 
#define	kSMS_DCS_Other_DC_CT_0		0x00	// 0 0 Class 0
#define	kSMS_DCS_Other_DC_CT_1		0x01	// 0 1 Class 1, ME specific
#define	kSMS_DCS_Other_DC_CT_2		0x02	// 1 0 Class 2, SIM specific
#define	kSMS_DCS_Other_DC_CT_3		0x03	// 1 1 Class 3, TE specific

////////////////////////////////////////////
// TP-Service-Centre-Time-Stamp (TP-SCTS) //
// 7 bytes								  //
////////////////////////////////////////////
#define kSMS_SCTS_Mask				variable	// 7 bytes

#define kSMS_Time_TZ_SignMask		0x08		// Time Zone Sign
#define kSMS_Time_TZ_SignPositive	0x00		// + Time Zone
#define kSMS_Time_TZ_SignNegative	0x08		// - Time Zone

////////////////////////////////
// TP-Validity-Period (TP-VP) //
// SMS-SUBMIT				  //
////////////////////////////////
#define	kSMS_VP_Mask				0xFF
#define kSMS_VP_R_Mask				0xFF	// 1 byte: Relative
//#define kSMS_VP_Absolute_Mask				// 7 bytes: same as TP-SCTS

#define kSMS_VP_E_Mask				0xFF	// 1 byte: Enhanced
#define kSMS_VP_E_ExtBit_Mask		0x80	// bit 7 Extension bit
#define kSMS_VP_E_ExtBit_ExtendedNo	0x00	// 0: no more TP-VP functionality indicator extension octets to follow
#define kSMS_VP_E_ExtBit_Extended	0x80	// 1: TP-VP functionality indicator is to be extended to another octet

#define kSMS_VP_E_SS_Mask			0x40	// bit 6 Single shot SM.
#define kSMS_VP_E_SS_Inactive		0x00
#define kSMS_VP_E_SS_Active			0x40	// 1: the SC is required to make up to one delivery attempt.
											// The TP-Validity Period, where present, will be applicable to the Single shot SM.
											// bits 5, 4, 3 Reserved
#define kSMS_VP_E_F_Mask			0x07	// bits 2, 1, 0 Validity Period Format.
#define kSMS_VP_E_F_NotSpecified	0x00	// 0 0 0 No Validity Period specified
#define kSMS_VP_E_F_AsForRelative	0x01	// 0 0 1 Validity Period is as specified for the relative case.
											// The following octet contains the TP-VP value as described in 9.2.3.12.1
#define kSMS_VP_E_F_RelativeInteger	0x02	// 0 1 0 Validity period is relative in integer representation and the following octet contains
											// the TP-VP value in the range 0 to 255 representing 0 to 255 seconds.
											// A TP-VP value of zero is undefined and reserved for future use.
#define kSMS_VP_E_F_RelativeSemiO	0x03	// 0 1 1 Validity period is relative in semi-octet representation.
											// The following 3 octets contain the relative time in Hours Minutes and Seconds giving
											// the length of the validity period counted from when the SMS SUBMIT is received by the SC.
											// The representation of time uses the same representation as the Hours, Minutes and Seconds in the TP-Service-Centre-Time-Stamp.
											// 1 0 0 Reserved
											// 1 0 1 Reserved
											// 1 1 0 Reserved
											// 1 1 1 Reserved
///////////////////////////////
// TP-Discharge-Time (TP-DT) //
// SMS-SUBMIT				 //
///////////////////////////////
#define kSMS_DT_Mask				variable // 7 bytes: same as TP-SCTS

//////////////////////////////////
// TP-Recipient-Address (TP-RA) //
// see address fields			//
//////////////////////////////////
#define kSMS_RA_Mask				variable			

///////////////////////
// TP-Status (TP-ST) //
// SMS-SUBMIT	     //
// SMS COMMANDS	     //
///////////////////////
#define kSMS_ST_Mask				0xff	// 1 byte
#define kSMS_ST_Type_Mask			0x80	// Bit 7
#define kSMS_ST_Type_Inactive		0x00
#define kSMS_ST_Type_Active			0x80

#define kSMS_ST_A_Mask				0x7F	// Active

// Short message transaction completed
#define kSMS_ST_C_SMReceived		0x00	// 0000000 Short message received by the SME
#define kSMS_ST_C_SMForwarded		0x01	// 0000001 Short message forwarded by the SC to the SME but the SC is unable to confirm delivery
#define kSMS_ST_C_SMRepalced		0x02	// 0000010 Short message replaced by the SC
											// 0000011..0001111 Reserved
											// 0010000..0011111 Values specific to each SC
// Temporary error, SC still trying to transfer SM
#define kSMS_ST_TE_ST_Congestion	0x20	// 0100000 Congestion
#define kSMS_ST_TE_ST_Busy			0x21	// 0100001 SME busy
#define kSMS_ST_TE_ST_NoResponse	0x22	// 0100010 No response from SME
#define kSMS_ST_TE_ST_Rejected		0x23	// 0100011 Service rejected
#define kSMS_ST_TE_ST_QOSNotAvail	0x24	// 0100100 Quality of service not available
#define kSMS_ST_TE_ST_Error			0x25	// 0100101 Error in SME
											// 0100110..0101111 Reserved
											// 0110000..0111111 Values specific to each SC 
// Permanent error, SC is not making any more transfer attempts
#define kSMS_ST_PE_NT_RemoteProcedure	0x40	// 1000000 Remote procedure error
#define kSMS_ST_PE_NT_IncompatibleDest	0x41	// 1000001 Incompatible destination
#define kSMS_ST_PE_NT_Rejected			0x42	// 1000010 Connection rejected by SME
#define kSMS_ST_PE_NT_NotObtainable		0x43	// 1000011 Not obtainable
#define kSMS_ST_PE_NT_QOSNotAvailable	0x44	// 1000100 Quality of service not available
#define kSMS_ST_PE_NT_NoInterworking	0x45	// 1000101 No interworking available
#define kSMS_ST_PE_NT_SMValidityExpired	0x46	// 1000110 SM Validity Period Expired
#define kSMS_ST_PE_NT_SMDeletedBySME	0x47	// 1000111 SM Deleted by originating SME
#define kSMS_ST_PE_NT_SMDeletedbySC		0x48	// 1001000 SM Deleted by SC Administration
#define kSMS_ST_PE_NT_SMDoesNotExist	0x49	// 1001001 SM does not exist (The SM may have previously existed in the SC but the SC no longer has knowledge of it or the SM may never have previously existed in the SC)
												// 1001010..1001111 Reserved
												// 1010000..1011111 Values specific to each SC
// Temporary error, SC is not making any more transfer attempts
#define kSMS_ST_TE_NT_Congestion	0x60	// 1100000 Congestion
#define kSMS_ST_TE_NT_Busy			0x61	// 1100001 SME busy
#define kSMS_ST_TE_NT_NoResponse	0x62	// 1100010 No response from SME
#define kSMS_ST_TE_NT_Rejected		0x63	// 1100011 Service rejected
#define kSMS_ST_TE_NT_QOSNotAvail	0x64	// 1100100 Quality of service not available
#define kSMS_ST_TE_NT_Error			0x65	// 1100101 Error in SME
											// 1100110..1101001 Reserved
											// 1101010..1101111 Reserved
											// 1110000..1111111 Values specific to each SC
//////////////////////////////////
// TP-User-Data-Length (TP-UDL) //
//////////////////////////////////
#define kSMS_UDL_Mask				0xFF	// 1 byte

///////////////////////////////
// TP-Message-Number (TP-MN) //
///////////////////////////////
#define kSMS_MN_Mask				0xFF	// 1 byte

/////////////////////////////
// TP-Command-Type (TP-CT) //
/////////////////////////////
#define kSMS_CT_Mask				0xFF	// 1 byte
#define kSMS_CT_Enquiry				0x00	// 00000000 Enquiry relating to previously submitted short message
#define kSMS_CT_Cancel				0x01	// 00000001 Cancel Status Report Request relating to previously submitted short message
#define kSMS_CT_Delete				0x02	// 00000010 Delete previously submitted Short Message
#define kSMS_CT_Enable				0x03	// 00000011 Enable Status Report Request relating to previously submitted short message
											// 00000100..00011111 Reserved
											// 11100000..11111111 Values specific for each SC
/////////////////////////////////////
// TP-Command-Data-Length (TP-CDL) //
/////////////////////////////////////
#define kSMS_CDL_Mask				0xFF	// 1 byte

/////////////////////////////
// TP-Command-Data (TP-CD) //
// Max: 157 bytes	   //
/////////////////////////////
#define kSMS_CD_Mask				variable

///////////////////////////////
// TP-Failure-Cause (TP-FCS) //
///////////////////////////////
#define kSMS_FCS_Mask				0xFF	// 1 byte
// 80 - 8F TP-PID errors
#define kSMS_FCS_PID_TI_NotSupported		0x80 	// Telematic interworking not supported
#define kSMS_FCS_PID_SMType0_NotSupported	0x81 	// Short message Type 0 not supported
#define kSMS_FCS_PID_SM_NotReplacable		0x82 	// Cannot replace short message
													// 0x83 - 0x8E Reserved
#define kSMS_FCS_PID_UnspecifiedError		0x8F 	// Unspecified TP-PID error
// 90 - 9F TP-DCS errors
#define kSMS_FCS_DCS_NotSupported			0x90 	// Data coding scheme (alphabet) not supported
#define kSMS_FCS_DCS_MCl_NotSupported		0x91 	// Message class not supported
													// 92 - 9E Reserved
#define kSMS_FCS_DCS_UnspecifiedError		0x9F 	// Unspecified TP-DCS error
// A0 - AF TP-Command Errors
#define kSMS_FCS_Command_Failed				0xA0 	// Command cannot be actioned
#define kSMS_FCS_Command_NotSupported		0xA1 	// Command unsupported
													// A2 - AE Reserved
#define kSMS_FCS_Command_UnspecifiedError	0xAF 	// Unspecified TP-Command error
#define kSMS_FCS_TPDU_NotSupported			0xB0 	// TPDU not supported
													// B1 - BF Reserved
#define kSMS_FCS_SC_Busy					0xC0 	// SC busy
#define kSMS_FCS_SC_NoSubscription			0xC1 	// No SC subscription
#define kSMS_FCS_SC_SystemFailure			0xC2 	// SC system failure
#define kSMS_FCS_SME_InvalidAddress			0xC3	// Invalid SME address
#define kSMS_FCS_SME_DestinationBarred		0xC4 	// Destination SME barred
#define kSMS_FCS_SM_Rejected				0xC5	// SM Rejected-Duplicate SM
#define kSMS_FCS_VPF_NotSupported			0xC6 	// TP-VPF not supported
#define kSMS_FCS_VP_NotSupported			0xC7 	// TP-VP not supported
													// C8 - CF Reserved
#define kSMS_FCS_SIM_SMSStorageFull			0xD0 	// SIM SMS storage full
#define kSMS_FCS_SIM_NoSMSStorage			0xD1 	// No SMS storage capability in SIM
#define kSMS_FCS_MS_Error					0xD2 	// Error in MS
#define kSMS_FCS_MemoryCapacityExceeded		0xD3 	// Memory Capacity Exceeded
#define kSMS_FCS_SIM_ToolkitBusy			0xD4 	// SIM Application Toolkit Busy
#define kSMS_FCS_SIM_DataDownloadError		0xD5 	// SIM data download error
													// 0xD6 - DF Reserved
#define kSMS_FCS_ApplicationSpecific		0xE0	// Values specific to an application
													// E0 - FE Values specific to an application
#define kSMS_FCS_UnspecifiedErrorCause		0xFF 	// Unspecified error cause

//////////////////////////
// TP-User Data (TP-UD) //
//////////////////////////
#define kSMS_UD_HeaderLength_Mask			0xFF	// Length of User Data Header 1 byte
#define kSMS_UD_IE_Id_Mask					0xFF	// Information-Element-Identifier "A" 1 byte
#define kSMS_UD_IE_Length_Mask				0xFF	// Length of Information-Element "A" 1 octet
#define kSMS_UD_IE_Mask						variable// Information-Element "A" Data 1 to "n" octets

#define kSMS_UD_IE_Id_Concat8BitsRef		0x00	// 00 Concatenated short messages, 8 bits reference number
#define kSMS_UD_IE_Id_Special				0x01	// 01 Special SMS Message Indication
#define kSMS_UD_IE_Id_Reserved1				0x02	// 02 Reserved
#define kSMS_UD_IE_Id_NotUsed				0x03	// 03 Value not used to avoid misinterpretation as <LF> character
#define kSMS_UD_IE_Id_AppPort8Bits			0x04	// 04 Application port addressing scheme, 8 bits address
#define kSMS_UD_IE_Id_AppPort16Bits			0x05	// 05 Application port addressing scheme, 16 bits address
#define kSMS_UD_IE_Id_SMSCContParam			0x06	// 06 SMSC Control Parameters
#define kSMS_UD_IE_Id_UDHSourceInd			0x07	// 07 UDH Source Indicator
#define kSMS_UD_IE_Id_Concat16BitsRef		0x08	// 08 Concatenated short message, 16 bits reference number
#define kSMS_UD_IE_Id_WirelessContl			0x09	// 09 Wireless Control Message Protocol
#define kSMS_UD_IE_Id_Reserved2				0x0A	// 0A - 6F Reserved for future use
#define kSMS_UD_IE_Id_STKSecurityHeader		0x70	// 70 - 7F SIM Toolkit Security Headers
#define kSMS_UD_IE_Id_SMEToSMESpecificUse	0x80	// 80 - 9F SME to SME specific use
#define kSMS_UD_IE_Id_Reserved3				0xA0	// A0 - BF Reserved for future use
#define kSMS_UD_IE_Id_SCSpecificUse			0xC0	// C0 - DF SC specific use
#define kSMS_UD_IE_Id_Reserved4				0xE0	// E0 - FF Reserved for future use

#define kSMS_UD_IE_Sp_T_Mask				0x7F	// Message Indication Type
#define kSMS_UD_IE_Sp_T_Voice				0x00	// Voice Message
#define kSMS_UD_IE_Sp_T_Fax					0x01	// Fax Message
#define kSMS_UD_IE_Sp_T_EMail				0x02	// Electronic Mail Message
#define kSMS_UD_IE_Sp_T_Other				0x03	// Other Message

#define kSMS_UD_IE_Sp_S_Mask				0x80
#define kSMS_UD_IE_Sp_S_Discard				0x00	// Discard Message after updating indication
#define kSMS_UD_IE_Sp_S_Store				0x80	// Strore Message


#define kSMS_UD_IE_SMSC_S_Co_Mask			0x01
#define kSMS_UD_IE_SMSC_S_Co_NoReport		0x00	// No report on Message transfer complete
#define kSMS_UD_IE_SMSC_S_Co_Report			0x01	// Report Message transfer complete
#define kSMS_UD_IE_SMSC_S_P_Mask			0x02
#define kSMS_UD_IE_SMSC_S_P_NoReport		0x00	// No report on Permanent error, transfer aborted
#define kSMS_UD_IE_SMSC_S_P_Report			0x02	// Report Permanent error, transfer aborted
#define kSMS_UD_IE_SMSC_S_T_A_Mask			0x04
#define kSMS_UD_IE_SMSC_S_T_A_NoReport		0x00	// No report on Temporary error, transfer aborted
#define kSMS_UD_IE_SMSC_S_T_A_Report		0x04	// Report Temporary error, transfer aborted
#define kSMS_UD_IE_SMSC_S_T_T_Mask			0x08
#define kSMS_UD_IE_SMSC_S_T_T_NoReport		0x00	// No report on Temporary error, SMSC still trying
#define kSMS_UD_IE_SMSC_S_T_T_Report		0x08	// Report Temporary error, SMSC still trying
#define kSMS_UD_IE_SMSC_S_Ca_Mask			0x40
#define kSMS_UD_IE_SMSC_S_Ca_Inactive		0x00	// No Activation
#define kSMS_UD_IE_SMSC_S_Ca_Active			0x40	// Cancel all other SR for this message
#define kSMS_UD_IE_SMSC_S_I_Mask			0x80
#define kSMS_UD_IE_SMSC_S_I_Inactive		0x00	// Do not include original UDH into the SR
#define kSMS_UD_IE_SMSC_S_I_Active			0x80	// Include original UDH into the SR

#define kSMS_UD_IE_UDH_S_OS					0x01	// UDH created by the original sender
#define kSMS_UD_IE_UDH_S_OR					0x02	// UDH created by the original receiver
#define kSMS_UD_IE_UDH_S_SMSC				0x03	// UDH created by the SMSC

////////////////////////////////////
// TP-Parameter-Indicator (TP-PI) //
// SMS-DELIVER-REPORT			  //
// SMS-SUBMIT-REPORT			  //
// SMS-STATUS-REPORT			  //		
////////////////////////////////////
#define kSMS_PI_Mask				0xFF
#define kSMS_PI_PID_Mask			0x01
#define kSMS_PI_DCS_Mask			0x02
#define kSMS_PI_UDL_Mask			0x04

#define kSMS_PI_PID_NotPresent		0x00
#define kSMS_PI_PID_Present			0x01

#define kSMS_PI_DCS_NotPresent		0x00
#define kSMS_PI_DCS_Present			0x02

#define kSMS_PI_UDL_NotPresent		0x00
#define kSMS_PI_UDL_Present			0x04

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////
// Address Field 		//
// Max Length: 12 bytes //
//////////////////////////
#define kSMS_AF_Mask				variable
#define kSMS_AF_Length				// One byte - Address-Length
#define kSMS_AF_TOA					// One byte - Type-of-Address
#define kSMS_AF_Value				// variable length - Address-Value Addr.

/////////////////////
// Type-of-Address //
// 1 byte		   //
/////////////////////
#define kSMS_TOA_Mask				0xFF
#define KSMS_TOA_Reserved_Mask		0x80	//
#define kSMS_TOA_TON_Mask			0x70
#define kSMS_TOA_NPI_Mask			0x0F

////////////////////
// Type-of-number //
// Bits 6 5 4	  //
////////////////////
#define kSMS_TON_Unknown			0x0		// 0 0 0 Unknown
#define kSMS_TON_International 		0x1		// 0 0 1 International number
#define kSMS_TON_National			0x2		// 0 1 0 National number
#define kSMS_TON_NetworkSpecific	0x3		// 0 1 1 Network specific number
#define kSMS_TON_Subscriber			0x4		// 1 0 0 Subscriber number
#define kSMS_TON_Amphanumeric		0x5		// 1 0 1 Alphanumeric, (coded according to GSM TS 03.38 7-bit default alphabet)
#define kSMS_TON_Abbreviated		0x6		// 1 1 0 Abbreviated number
#define kSMS_TON_Reserved			0x7		// 1 1 1 Reserved for extension

///////////////////////////////////
// Numbering-plan-identification //
// Bits 3 2 1 0					 //
// Applies for TON: 000,001,010  //
///////////////////////////////////
#define kSMS_NPI_Unknown			0x0		// 0 0 0 0 Unknown
#define kSMS_NPI_ISDN				0x1		// 0 0 0 1 ISDN/telephone numbering plan (E.164/E.163)
#define kSMS_NPI_Data				0x3		// 0 0 1 1 Data numbering plan (X.121)
#define kSMS_NPI_Telex				0x4		// 0 1 0 0 Telex numbering plan
#define kSMS_NPI_National			0x8		// 1 0 0 0 National numbering plan
#define kSMS_NPI_Private			0x9		// 1 0 0 1 Private numbering plan
#define kSMS_NPI_ERMES				0xA		// 1 0 1 0 ERMES numbering plan (ETSI DE/PS 3 01-3)
#define kSMS_NPI_Reserved			0xF		// 1 1 1 1 Reserved for extension
											// All other values are reserved.
//////////////////
// Time - Month //
//////////////////
#define kSMS_Time_Mo_January		0x1
#define kSMS_Time_Mo_February		0x2
#define kSMS_Time_Mo_March			0x3
#define kSMS_Time_Mo_April			0x4
#define kSMS_Time_Mo_May			0x5
#define kSMS_Time_Mo_June			0x6
#define kSMS_Time_Mo_July			0x7
#define kSMS_Time_Mo_August			0x8
#define kSMS_Time_Mo_September		0x9
#define kSMS_Time_Mo_October		0xA
#define kSMS_Time_Mo_November		0xB
#define kSMS_Time_Mo_December		0xC	

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#endif // SMSCODECDEFINES_H